# 通知設計書 1-Syslog INFO通知

## 概要

本ドキュメントは、Horse WebフレームワークのDaemonプロバイダーにおけるSyslog INFO通知機能の設計を記述する。デーモンプロセス起動時にシステムログ（syslog）へサーバー起動情報を記録する通知機能である。

### 本通知の処理概要

本通知は、LinuxデーモンとしてHorseサーバーが起動する際に、システムログファシリティを通じて起動完了情報を記録する機能を提供する。

**業務上の目的・背景**：Linuxサーバー環境でデーモンとして動作するWebサーバーの運用において、サーバーの起動状態をシステムログに記録することは運用監視の基本要件である。この通知により、システム管理者はsyslogを通じてサーバーの起動を確認でき、監視ツールによる自動検知やログ分析が可能となる。

**通知の送信タイミング**：デーモンプロセスが正常に起動し、HTTPサーバーがリスニング状態になった直後に送信される。具体的には、`TIdHTTPWebBrokerBridge.StartListening`の呼び出し成功後、`DoOnListen`コールバック実行後に送信される。

**通知の受信者**：システムログデーモン（syslogd/rsyslogd）を経由して、ログファイル（通常は`/var/log/daemon.log`または`/var/log/messages`）に記録される。受信者はシステム管理者、運用監視システム、ログ分析ツールである。

**通知内容の概要**：サーバーがリスニングを開始したホストアドレスとポート番号を含む起動メッセージ。形式は「Server is running on {host}:{port}」である。

**期待されるアクション**：システム管理者はサーバーが正常に起動したことを確認できる。監視システムは起動イベントを検知し、必要に応じてアラートや通知を抑止できる。

## 通知種別

システムログ（Syslog） - LOG_INFO優先度

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | INFO（LOG_INFO = 6） |
| リトライ | 無し |

### 送信先決定ロジック

syslogシステムコールにより、OSのシステムログデーモンに送信される。ログのルーティングはsyslog設定（`/etc/rsyslog.conf`等）に従う。ファシリティは`LOG_DAEMON`（デーモン関連メッセージ）が使用される。

## 通知テンプレート

### システムログ通知の場合

| 項目 | 内容 |
|-----|------|
| ファシリティ | LOG_DAEMON（3 << 3 = 24） |
| 優先度 | LOG_INFO（6） |
| オプション | LOG_PID \| LOG_NDELAY |
| 形式 | テキスト |

### 本文テンプレート

```
Server is running on %s:%d
```

実際の出力例：
```
Server is running on 0.0.0.0:9000
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | システムログ通知のため添付ファイルは使用しない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| FHost | サーバーがバインドするホストアドレス | THorseProvider.FHost（デフォルト: '0.0.0.0'） | Yes |
| FPort | サーバーがリスニングするポート番号 | THorseProvider.FPort（デフォルト: 9000） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| デーモン起動 | InternalListenメソッド実行 | HTTPサーバーのStartListening成功 | デーモンプロセスが正常に起動しリスニング開始後に送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 起動失敗時 | StartListeningで例外が発生した場合は送信されない |
| 非デーモンモード | HORSE_DAEMONが定義されていない場合は本コードは実行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[InternalListen呼び出し] --> B[openlogでsyslog初期化]
    B --> C[fork処理でデーモン化]
    C --> D[HTTPサーバー設定]
    D --> E[StartListening実行]
    E --> F{StartListening成功?}
    F -->|成功| G[FRunning = True]
    G --> H[DoOnListenコールバック実行]
    H --> I[Syslog LOG_INFO 送信]
    I --> J[イベントループ開始]
    F -->|失敗| K[Syslog LOG_ERR 送信]
    K --> L[例外処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 本通知はデータベースを使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知はデータベースを更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| syslog送信失敗 | syslogデーモンが停止している場合 | OSレベルで処理されるため、アプリケーション側での対処は不要 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（通常は起動時1回のみ） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

デーモン起動時に即座に送信される。時間帯の制限はない。

## セキュリティ考慮事項

- ホストアドレスとポート番号のみをログに記録するため、機密情報の漏洩リスクは低い
- syslogへの書き込み権限はOSレベルで管理される
- LOG_PIDオプションにより、プロセスIDがログに含まれ、追跡が可能

## 備考

- `HORSE_DAEMON`コンパイラディレクティブが定義されている場合のみ有効
- Free Pascal（FPC）環境では別のデーモン実装（`Horse.Provider.FPC.Daemon.pas`）が使用される
- START_RUNNING定数は`Horse.Constants.pas`で定義されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

syslogの優先度定数とメッセージフォーマットを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ThirdParty.Posix.Syslog.pas | `src/ThirdParty.Posix.Syslog.pas` | syslogのAPI定義、優先度定数（LOG_INFO=6）、ファシリティ定数（LOG_DAEMON）を確認 |
| 1-2 | Horse.Constants.pas | `src/Horse.Constants.pas` | START_RUNNING定数（行12）、DEFAULT_HOST、DEFAULT_PORTを確認 |

**読解のコツ**: Posix APIのラッパーとして、Delphiから直接libcのsyslog関数を呼び出している。`_syslog`は可変引数を受け取る外部関数宣言。

#### Step 2: エントリーポイントを理解する

デーモン起動処理の流れを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | InternalListenメソッド（行195-280）がメインの起動処理 |

**主要処理フロー**:
1. **行201**: TEvent.Createでイベントオブジェクト生成
2. **行203**: openlogでsyslog初期化（LOG_PID | LOG_NDELAY, LOG_DAEMON）
3. **行204-228**: fork処理によるデーモン化
4. **行256-257**: HTTPサーバーのActive設定とStartListening
5. **行258**: FRunning := True
6. **行259**: DoOnListenコールバック実行
7. **行260**: `Syslog(LOG_INFO, Format(START_RUNNING, [FHost, FPort]))` - **ここがINFO通知の送信箇所**

#### Step 3: syslog送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ThirdParty.Posix.Syslog.pas | `src/ThirdParty.Posix.Syslog.pas` | Syslogプロシージャ（行88-100）の実装を確認 |

**主要処理フロー**:
- **行88-95**: 引数なしバージョンのSyslog - TMarshaller.AsAnsiでUTF-8変換後、_syslogを呼び出し
- **行97-100**: Format付きバージョン - 内部でFormatを呼び出し、引数なしバージョンに委譲

### プログラム呼び出し階層図

```
THorseProvider.Listen (public)
    │
    └─ THorseProvider.InternalListen (private, 行195)
           │
           ├─ openlog (行203) - syslog初期化
           │
           ├─ fork (行206, 216) - デーモン化処理
           │
           ├─ TIdHTTPWebBrokerBridge.StartListening (行257)
           │
           ├─ DoOnListen (行259) - コールバック実行
           │
           └─ Syslog(LOG_INFO, ...) (行260) - INFO通知送信
                  │
                  └─ ThirdParty.Posix.Syslog.Syslog (行88)
                         │
                         └─ _syslog (libc外部関数)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

FHost (string)      ───┬──▶ Format(START_RUNNING,        ───▶ syslog
'0.0.0.0'              │      [FHost, FPort])                  /var/log/daemon.log
                       │           │
FPort (Integer)    ───┘           │
9000                              ▼
                           "Server is running on
                            0.0.0.0:9000"
                                  │
                                  ▼
                           Syslog(LOG_INFO, message)
                                  │
                                  ▼
                           TMarshaller.AsAnsi (UTF-8)
                                  │
                                  ▼
                           _syslog(LOG_INFO, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | ソース | デーモンプロバイダーのメイン実装、INFO通知の送信元 |
| ThirdParty.Posix.Syslog.pas | `src/ThirdParty.Posix.Syslog.pas` | ソース | syslog APIのDelphiラッパー |
| Horse.Constants.pas | `src/Horse.Constants.pas` | ソース | START_RUNNING定数、DEFAULT_HOST/PORT定義 |
| Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | ソース | プロバイダー基底クラス |
